#********************************************************************************
#If you should have any comments, suggestions or improvements to these samples, 
#we welcome you to contact us at SampleCode@melissadata.com also please visit our 
#developers bulletin board at forum.melissadata.com.
#********************************************************************************

require 'mdPhoneRubyWrapper'


	#/********************** LICENSE STRINGS *************************
	#      To unlock the full functionality of Phone Object,         
	#      	     Or to obtain a Demo License String                  
	#  please call a sales representative at 1-800-MELISSA ext. 3    
	#          (1-800-635-4772 x3) for a license string.             
	#                 REPLACE "DEMO" with LICENSE STRING                    

  #   SetLicenseString will also check for a valid license in the 
  #   MDPHONE_LICENSE(Environment) variable. This allows you to  
  #   modify the license without recompiling the project
	#*****************************************************************/

License = "DEMO"

  # ********************** DATA FILE PATH  ***********************
  #  File location path is set to the default Data File location
  #  Change this value if you installed the data files to a       
  #  different folder.                                            
  #  The Data Files Directory must contain the following files:   
  #  mdAddr.dat, mdPhone.dat, mdPhone.idx, and ZIPNPA.txt
  # **************************************************************

DataPath = "C:\\Program Files\\Melissa Data\\DQT\\Data"

#Create a new Phone and Global Phone Object
phoneObj = MdPhoneRubyWrapper::MdPhone.new()
globalPhoneObj = MdPhoneRubyWrapper::MdGlobalPhone.new()

#Set the licesne strings
phoneObj.SetLicenseString(License)
globalPhoneObj.SetLicenseString(License)

#Initialize the Phone Object
if(phoneObj.Initialize(DataPath) != 0)
  print phoneObj.GetInitializeErrorString()
  Process.exit
end

#Initialize the Global Phone Object
if(globalPhoneObj.Initialize(DataPath) != 0)
  print globalPhoneObj.GetInitializeErrorString()
  Process.exit
end

print "\n"
print "******Global Phone Object Sample****** \n"
print "Build Number : "  + globalPhoneObj.GetBuildNumber()  + "\n"
print "Database Date: " + globalPhoneObj.GetDatabaseDate() + "\n"
print "\n\n"
print "Enter phone (Ex:422304850) : "
globalPhoneNumber = gets
print "Enter country name (Ex: JPN) : "
countryname = gets
print "Enter country of origin (Ex: USA) : "
countryoforigin = gets

print "\n"
globalPhoneObj.Lookup(globalPhoneNumber, countryname, countryoforigin)
resultString = globalPhoneObj.GetResults()

if ((resultString.include? "PE") == true)
  if ((resultString.include? "PE01") == true)
    print "Error in Lookup: Area Code Not valid\n"
  end
  if ((resultString.include? "PE02") == true)
    print "Error in Lookup: Blank Phone Number\n"
  end
  if ((resultString.include? "PE03") == true)
    print "Error in Lookup: Phone Number Not valid\n"
  end
  if ((resultString.include? "PE04") == true)
    print "Error in Lookup: Input has Multiple Matches\n"
  end
  if ((resultString.include? "PE05") == true)
    print "Error in Lookup: Phone Prefix Not Valid\n"
  end
  if ((resultString.include? "PE06") == true)
    print "Error in Lookup: Zip Code Not Valid\n"
  end
  if ((resultString.include? "PE08") == true)
    print "Error in Lookup: No country inputted\n"
  end
  if ((resultString.include? "PE09") == true)
    print "Error in Lookup: Subscriber number out of range\n"
  end
  if ((resultString.include? "PE10") == true)
    print "Error in Lookup: Incorrect / misspelled country inputd\n"
  end
end				
        
if (((resultString.include? "PS01") == true) or ((resultString.include? "PS02") == true))
  if ((resultString.include? "PS01") == true)
    print "      Validated: Phone Validated to 10 Digits\n"
  elsif ((resultString.include? "PS02") == true)
    print "      Validated: Phone Validated to 7 Digits\n"
  end
				
  if ((resultString.include? "PS07") == true)
    print "  Exchange Type: Cellular\n"
  elsif ((resultString.include? "PS08") == true)
    print "  Exchange Type: Land Line\n"
  elsif ((resultString.include? "PS09") == true)
    print "  Exchange Type: VOIP\n"
  elsif ((resultString.include? "PS13") == true)
	print "  Exchange Type: International toll-free\n"
  elsif ((resultString.include? "PS14") == true)
	print "  Exchange Type: International number incurring higher charge rate\n"
  end
  
  if ((resultString.include? "PS10") == true)
    print "     Phone Type: Residential\n"
  elsif ((resultString.include? "PS11") == true)
    print "     Phone Type: Business\n"
  elsif ((resultString.include? "PS12") == true)
    print "     Phone Type: Small/Home Office\n"
  end
  
  print "\n"
  print "====================================\n"
  print "  Global Phone Obj Lookup Results\n"
  print "====================================\n"
  print "                Phone Number : " + globalPhoneObj.GetPhoneNumber()+ "\n"
  print "               Nation Prefix : " + globalPhoneObj.GetNationPrefix()+ "\n"
  print "		 Itnernational Prefix : " + globalPhoneObj.GetInternationalPrefix()+ "\n"
  print "   National Destination Code : " + globalPhoneObj.GetNationalDestinationCode() + "\n"
  print "             Locality (City) : " + globalPhoneObj.GetLocality()+ "\n"
  print "Administrative Area (State)  : " + globalPhoneObj.GetAdministrativeArea() + "\n"
  print "                     Country : " + globalPhoneObj.GetCountry()+ "\n"
  print "                Country Code : " + globalPhoneObj.GetCountryCode()+ "\n"
  print "                         DST : " + globalPhoneObj.GetDST() + "\n"
  print "                    Language : " + globalPhoneObj.GetLanguage() + "\n"
  print "                    Latitude : " + globalPhoneObj.GetLatitude() + "\n"
  print "                   Longitude : " + globalPhoneObj.GetLongitude()+ "\n"
  print "           Subscriber Number : " + globalPhoneObj.GetSubscriberNumber() + "\n\n"
  print "                         UTC : " + globalPhoneObj.GetUTC()+ "\n"
else
  print "PS01 or PS02 not included in result string\n"
  print "Result String: " + globalPhoneObj.GetResults() + "\n"
end
print "\n"
print "******Phone Object Sample****** \n"
print "Build Number : "  + phoneObj.GetBuildNumber()  + "\n"
print "Database Date: " + phoneObj.GetDatabaseDate() + "\n"
print "\n\n"
print "If running in DEMO mode, only NV records will be validated!\n\n"
print "Enter phone: "
phone = gets
print "Enter zip  : "
zip = gets

print "\n"
phoneObj.Lookup(phone,zip)
resultString = phoneObj.GetResults()

if ((resultString.include? "PE") == true)
  if ((resultString.include? "PE01") == true)
    print "Error in Lookup: Area Code Not valid\n"
  end
  if ((resultString.include? "PE02") == true)
    print "Error in Lookup: Blank Phone Number\n"
  end
  if ((resultString.include? "PE03") == true)
    print "Error in Lookup: Phone Number Not valid\n"
  end
  if ((resultString.include? "PE04") == true)
    print "Error in Lookup: Input has Multiple Matches\n"
  end
  if ((resultString.include? "PE05") == true)
    print "Error in Lookup: Phone Prefix Not Valid\n"
  end
  if ((resultString.include? "PE06") == true)
    print "Error in Lookup: Zip Code Not Valid\n"
  end
  if ((resultString.include? "PE08") == true)
    print "Error in Lookup: No country inputted\n"
  end
  if ((resultString.include? "PE09") == true)
    print "Error in Lookup: Subscriber number out of range\n"
  end
  if ((resultString.include? "PE10") == true)
    print "Error in Lookup: Incorrect / misspelled country inputd\n"
  end
end				
        
if (((resultString.include? "PS01") == true) or ((resultString.include? "PS02") == true))
  if ((resultString.include? "PS01") == true)
    print "      Validated: Phone Validated to 10 Digits\n"
  elsif ((resultString.include? "PS02") == true)
    print "      Validated: Phone Validated to 7 Digits\n"
  end
				
  if ((resultString.include? "PS07") == true)
    print "  Exchange Type: Cellular\n"
  elsif ((resultString.include? "PS08") == true)
    print "  Exchange Type: Land Line\n"
  elsif ((resultString.include? "PS09") == true)
    print "  Exchange Type: VOIP\n"
  elsif ((resultString.include? "PS13") == true)
	print "  Exchange Type: International toll-free\n"
  elsif ((resultString.include? "PS14") == true)
	print "  Exchange Type: International number incurring higher charge rate\n"
  end
  
  if ((resultString.include? "PS10") == true)
    print "     Phone Type: Residential\n"
  elsif ((resultString.include? "PS11") == true)
    print "     Phone Type: Business\n"
  elsif ((resultString.include? "PS12") == true)
    print "     Phone Type: Small/Home Office\n"
  end

  
  print "\n"
  print "==============================\n"
  print "  Phone Obj Lookup Results\n"
  print "==============================\n"
  print "     Latitude : " + phoneObj.GetLatitude()+ "\n"
  print "    Longitude : " + phoneObj.GetLongitude()+ "\n"
  print "         City : " + phoneObj.GetCity() + "\n"
  print "        State : " + phoneObj.GetState()+ "\n"
  print "  County Name : " + phoneObj.GetCountyName() + "\n"
  print "  County Fips : " + phoneObj.GetCountyFips()+ "\n"
  print " Country Code : " + phoneObj.GetCountryCode()+ "\n"
  print "          MSA : " + phoneObj.GetMsa() + "\n"
  print "         PMSA : " + phoneObj.GetPmsa() + "\n"
  print "     Timezone : " + phoneObj.GetTimeZone() + "\n"
  print "Timezone Code : " + phoneObj.GetTimeZoneCode()+ "\n"
  print " Results Code : " + phoneObj.GetResults() + "\n\n"
  
  print "==========================================\n"
  print "     Distance and Bearing from Phone\n"
  print "Lat / Long of US Capital: 38.889722  -77.0075\n"
  print "==========================================\n"
  print "Distance: ", phoneObj.ComputeDistance(phoneObj.GetLatitude().to_f,
                                                                      phoneObj.GetLongitude().to_f,
                                                                      38.889722,
                                                                      -77.0075)," miles\n"
  print " Bearing: ", phoneObj.ComputeBearing(phoneObj.GetLatitude().to_f,
                                                                      phoneObj.GetLongitude().to_f,
                                                                      38.889722,
                                                                      -77.0075)," degrees\n"
else
  print "PS01 or PS02 not included in result string\n"
  print "Result String: " + phoneObj.GetResults() + "\n"
end                                                                    
	
if (zip.strip != "") 
  phoneObj.CorrectAreaCode(phone,zip)
  
  
  print "\n"
  print "=============================\n"
  print "  Correct Area Code Results\n"
  print "=============================\n"
  print "  Area Code: " + phoneObj.GetAreaCode() + "\n"
  print "NewAreaCode: " + phoneObj.GetNewAreaCode()  + "\n"
  print "     Prefix: " + phoneObj.GetPrefix() + "\n"
  print "     Suffix: " + phoneObj.GetSuffix() + "\n"
  print "  Extension: " + phoneObj.GetExtension()  + "\n"
  print "      State: " + phoneObj.GetState() + "\n\n"
end